/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PrivateConnectivity: ImageVector
    get() {
        if (_privateConnectivity != null) {
            return _privateConnectivity!!
        }
        _privateConnectivity = materialIcon(name = "Filled.PrivateConnectivity") {
            materialPath {
                moveTo(18.93f, 11.0f)
                curveToRelative(-0.49f, -3.39f, -3.4f, -6.0f, -6.93f, -6.0f)
                reflectiveCurveToRelative(-6.44f, 2.61f, -6.93f, 6.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.07f)
                curveToRelative(0.49f, 3.39f, 3.4f, 6.0f, 6.93f, 6.0f)
                reflectiveCurveToRelative(6.44f, -2.61f, 6.93f, -6.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(18.93f)
                close()
                moveTo(15.0f, 14.5f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -1.21f, 1.08f, -2.18f, 2.34f, -1.97f)
                curveTo(13.32f, 7.69f, 14.0f, 8.61f, 14.0f, 9.61f)
                verticalLineToRelative(0.89f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(14.5f)
                close()
                moveTo(12.75f, 13.0f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                reflectiveCurveToRelative(-0.75f, -0.34f, -0.75f, -0.75f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                reflectiveCurveTo(12.75f, 12.59f, 12.75f, 13.0f)
                close()
                moveTo(13.0f, 9.5f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveTo(13.0f, 8.95f, 13.0f, 9.5f)
                close()
            }
        }
        return _privateConnectivity!!
    }

private var _privateConnectivity: ImageVector? = null
