/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ModeFanOff: ImageVector
    get() {
        if (_modeFanOff != null) {
            return _modeFanOff!!
        }
        _modeFanOff = materialIcon(name = "TwoTone.ModeFanOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.5f, 10.0f)
                curveTo(4.42f, 10.0f, 4.0f, 10.03f, 4.0f, 10.6f)
                curveToRelative(0.0f, 2.0f, 0.82f, 3.4f, 2.0f, 3.4f)
                curveToRelative(0.51f, 0.0f, 0.89f, -0.12f, 2.69f, -0.86f)
                curveToRelative(-0.07f, -0.2f, -0.12f, -0.41f, -0.15f, -0.62f)
                curveToRelative(-1.48f, -0.33f, -2.49f, -0.89f, -3.39f, -2.16f)
                curveTo(4.93f, 10.05f, 4.77f, 10.0f, 4.5f, 10.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.0f, 19.5f)
                curveToRelative(0.0f, 0.08f, 0.03f, 0.5f, 0.6f, 0.5f)
                curveToRelative(2.0f, 0.0f, 3.4f, -0.82f, 3.4f, -2.0f)
                curveToRelative(0.0f, -0.38f, -0.07f, -0.69f, -0.42f, -1.59f)
                lineToRelative(-0.97f, -0.97f)
                curveToRelative(-0.03f, 0.01f, -0.06f, 0.02f, -0.09f, 0.02f)
                curveToRelative(-0.33f, 1.48f, -0.89f, 2.49f, -2.16f, 3.39f)
                curveTo(10.05f, 19.07f, 10.0f, 19.23f, 10.0f, 19.5f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.65f, 5.15f)
                curveTo(13.95f, 4.93f, 14.0f, 4.77f, 14.0f, 4.5f)
                curveTo(14.0f, 4.42f, 13.97f, 4.0f, 13.4f, 4.0f)
                curveToRelative(-2.0f, 0.0f, -3.4f, 0.82f, -3.4f, 2.0f)
                curveToRelative(0.0f, 0.38f, 0.07f, 0.69f, 0.42f, 1.59f)
                lineToRelative(1.05f, 1.05f)
                lineToRelative(0.02f, -0.1f)
                curveTo(11.82f, 7.06f, 12.37f, 6.04f, 13.65f, 5.15f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.85f, 13.65f)
                curveToRelative(0.21f, 0.3f, 0.38f, 0.35f, 0.65f, 0.35f)
                curveToRelative(0.08f, 0.0f, 0.5f, -0.03f, 0.5f, -0.6f)
                curveToRelative(0.0f, -2.0f, -0.82f, -3.4f, -2.0f, -3.4f)
                curveToRelative(-0.51f, 0.0f, -0.89f, 0.12f, -2.69f, 0.86f)
                curveToRelative(0.07f, 0.2f, 0.12f, 0.41f, 0.15f, 0.62f)
                curveTo(16.94f, 11.82f, 17.96f, 12.37f, 18.85f, 13.65f)
                close()
            }
            materialPath {
                moveTo(10.0f, 6.0f)
                curveToRelative(0.0f, -1.18f, 1.4f, -2.0f, 3.4f, -2.0f)
                curveTo(13.97f, 4.0f, 14.0f, 4.42f, 14.0f, 4.5f)
                curveToRelative(0.0f, 0.27f, -0.05f, 0.43f, -0.35f, 0.65f)
                curveToRelative(-1.27f, 0.9f, -1.83f, 1.91f, -2.16f, 3.39f)
                lineToRelative(-0.02f, 0.1f)
                lineToRelative(7.25f, 7.25f)
                curveTo(18.96f, 15.95f, 19.22f, 16.0f, 19.5f, 16.0f)
                curveToRelative(1.22f, 0.0f, 2.5f, -0.95f, 2.5f, -2.6f)
                curveTo(22.0f, 9.91f, 20.11f, 8.0f, 18.0f, 8.0f)
                curveToRelative(-1.06f, 0.0f, -1.64f, 0.29f, -3.91f, 1.19f)
                curveToRelative(-0.19f, -0.14f, -0.4f, -0.27f, -0.62f, -0.37f)
                curveToRelative(0.25f, -1.03f, 0.61f, -1.53f, 1.33f, -2.04f)
                curveTo(15.61f, 6.21f, 16.0f, 5.44f, 16.0f, 4.5f)
                curveTo(16.0f, 3.28f, 15.05f, 2.0f, 13.4f, 2.0f)
                curveToRelative(-3.08f, 0.0f, -4.92f, 1.47f, -5.32f, 3.26f)
                lineToRelative(2.33f, 2.33f)
                curveTo(10.07f, 6.69f, 10.0f, 6.38f, 10.0f, 6.0f)
                close()
                moveTo(18.0f, 10.0f)
                curveToRelative(1.18f, 0.0f, 2.0f, 1.4f, 2.0f, 3.4f)
                curveToRelative(0.0f, 0.57f, -0.42f, 0.6f, -0.5f, 0.6f)
                curveToRelative(-0.27f, 0.0f, -0.43f, -0.05f, -0.65f, -0.35f)
                curveToRelative(-0.9f, -1.27f, -1.91f, -1.83f, -3.39f, -2.16f)
                curveToRelative(-0.03f, -0.22f, -0.08f, -0.42f, -0.15f, -0.62f)
                curveTo(17.11f, 10.12f, 17.49f, 10.0f, 18.0f, 10.0f)
                close()
            }
            materialPath {
                moveTo(1.39f, 4.22f)
                lineToRelative(3.89f, 3.89f)
                curveTo(5.04f, 8.05f, 4.78f, 8.0f, 4.5f, 8.0f)
                curveTo(3.28f, 8.0f, 2.0f, 8.95f, 2.0f, 10.6f)
                curveTo(2.0f, 14.09f, 3.89f, 16.0f, 6.0f, 16.0f)
                curveToRelative(1.06f, 0.0f, 1.64f, -0.29f, 3.91f, -1.19f)
                curveToRelative(0.19f, 0.14f, 0.4f, 0.27f, 0.62f, 0.37f)
                curveToRelative(-0.25f, 1.03f, -0.61f, 1.53f, -1.33f, 2.04f)
                curveTo(8.39f, 17.79f, 8.0f, 18.56f, 8.0f, 19.5f)
                curveToRelative(0.0f, 1.22f, 0.95f, 2.5f, 2.6f, 2.5f)
                curveToRelative(3.08f, 0.0f, 4.92f, -1.47f, 5.32f, -3.26f)
                lineToRelative(3.86f, 3.86f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                close()
                moveTo(12.52f, 15.46f)
                curveToRelative(0.03f, 0.0f, 0.06f, -0.02f, 0.09f, -0.02f)
                lineToRelative(0.97f, 0.97f)
                curveTo(13.93f, 17.31f, 14.0f, 17.62f, 14.0f, 18.0f)
                curveToRelative(0.0f, 1.18f, -1.4f, 2.0f, -3.4f, 2.0f)
                curveToRelative(-0.57f, 0.0f, -0.6f, -0.42f, -0.6f, -0.5f)
                curveToRelative(0.0f, -0.27f, 0.05f, -0.43f, 0.35f, -0.65f)
                curveTo(11.63f, 17.96f, 12.18f, 16.94f, 12.52f, 15.46f)
                close()
                moveTo(8.54f, 12.52f)
                curveToRelative(0.03f, 0.22f, 0.08f, 0.42f, 0.15f, 0.62f)
                curveTo(6.89f, 13.88f, 6.51f, 14.0f, 6.0f, 14.0f)
                curveToRelative(-1.18f, 0.0f, -2.0f, -1.4f, -2.0f, -3.4f)
                curveTo(4.0f, 10.03f, 4.42f, 10.0f, 4.5f, 10.0f)
                curveToRelative(0.27f, 0.0f, 0.43f, 0.05f, 0.65f, 0.35f)
                curveTo(6.04f, 11.63f, 7.06f, 12.18f, 8.54f, 12.52f)
                close()
            }
        }
        return _modeFanOff!!
    }

private var _modeFanOff: ImageVector? = null
