/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.DesignServices: ImageVector
    get() {
        if (_designServices != null) {
            return _designServices!!
        }
        _designServices = materialIcon(name = "TwoTone.DesignServices") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.91f, 9.28f)
                lineToRelative(-1.3f, -1.3f)
                lineToRelative(-9.61f, 9.61f)
                lineToRelative(0.0f, 1.41f)
                lineToRelative(1.41f, 0.0f)
                lineToRelative(9.61f, -9.61f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.83f, 8.93f)
                lineToRelative(-1.2f, -1.2f)
                lineToRelative(-1.19f, 1.19f)
                lineToRelative(-1.42f, -1.42f)
                lineToRelative(1.19f, -1.18f)
                lineToRelative(-1.27f, -1.28f)
                lineToRelative(0.0f, 0.0f)
                lineToRelative(-1.9f, 1.9f)
                lineToRelative(3.89f, 3.89f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.27f, 14.38f)
                lineToRelative(-1.2f, -1.21f)
                lineToRelative(-1.9f, 1.9f)
                lineToRelative(3.89f, 3.89f)
                lineToRelative(1.9f, -1.9f)
                lineToRelative(-1.27f, -1.27f)
                lineToRelative(-1.19f, 1.19f)
                lineToRelative(-1.42f, -1.41f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.021f, 6.558f)
                lineToRelative(1.414f, -1.414f)
                lineToRelative(1.414f, 1.414f)
                lineToRelative(-1.414f, 1.414f)
                close()
            }
            materialPath {
                moveTo(20.97f, 5.86f)
                lineToRelative(-2.83f, -2.83f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-4.49f, 4.49f)
                lineTo(8.35f, 3.63f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineToRelative(-1.9f, 1.9f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(3.89f, 3.89f)
                lineTo(3.0f, 16.76f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(4.24f)
                lineToRelative(4.52f, -4.52f)
                lineToRelative(3.89f, 3.89f)
                curveToRelative(0.95f, 0.95f, 2.23f, 0.6f, 2.83f, 0.0f)
                lineToRelative(1.9f, -1.9f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-3.89f, -3.89f)
                lineToRelative(4.49f, -4.49f)
                curveTo(21.36f, 6.88f, 21.36f, 6.25f, 20.97f, 5.86f)
                close()
                moveTo(5.04f, 6.94f)
                lineToRelative(1.89f, -1.9f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                lineToRelative(1.27f, 1.27f)
                lineTo(7.02f, 7.5f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.19f, -1.19f)
                lineToRelative(1.2f, 1.2f)
                lineToRelative(-1.9f, 1.9f)
                lineTo(5.04f, 6.94f)
                close()
                moveTo(6.41f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-1.41f)
                lineToRelative(9.61f, -9.61f)
                lineToRelative(1.3f, 1.3f)
                lineToRelative(0.11f, 0.11f)
                lineTo(6.41f, 19.0f)
                close()
                moveTo(16.5f, 16.98f)
                lineToRelative(1.19f, -1.19f)
                lineToRelative(1.27f, 1.27f)
                lineToRelative(-1.9f, 1.9f)
                lineToRelative(-3.89f, -3.89f)
                lineToRelative(1.9f, -1.9f)
                lineToRelative(1.2f, 1.2f)
                lineToRelative(-1.19f, 1.19f)
                lineTo(16.5f, 16.98f)
                close()
                moveTo(17.44f, 7.98f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(1.41f, 1.41f)
                lineTo(17.44f, 7.98f)
                close()
            }
        }
        return _designServices!!
    }

private var _designServices: ImageVector? = null
