/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PermCameraMic: ImageVector
    get() {
        if (_permCameraMic != null) {
            return _permCameraMic!!
        }
        _permCameraMic = materialIcon(name = "Sharp.PermCameraMic") {
            materialPath {
                moveTo(22.0f, 5.0f)
                horizontalLineToRelative(-5.17f)
                lineTo(15.0f, 3.0f)
                lineTo(9.0f, 3.0f)
                lineTo(7.17f, 5.0f)
                lineTo(2.0f, 5.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-2.09f)
                curveToRelative(-2.83f, -0.48f, -5.0f, -2.94f, -5.0f, -5.91f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, 2.97f, -2.17f, 5.43f, -5.0f, 5.91f)
                lineTo(13.0f, 21.0f)
                horizontalLineToRelative(9.0f)
                lineTo(22.0f, 5.0f)
                close()
                moveTo(14.0f, 13.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                lineTo(10.0f, 9.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                close()
            }
        }
        return _permCameraMic!!
    }

private var _permCameraMic: ImageVector? = null
