/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoMeals: ImageVector
    get() {
        if (_noMeals != null) {
            return _noMeals!!
        }
        _noMeals = materialIcon(name = "Sharp.NoMeals") {
            materialPath {
                moveTo(16.0f, 14.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.76f, 2.24f, -4.0f, 5.0f, -4.0f)
                verticalLineToRelative(16.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(14.0f)
                horizontalLineTo(16.0f)
                close()
                moveTo(20.49f, 23.31f)
                lineTo(10.02f, 12.85f)
                curveTo(9.69f, 12.94f, 9.36f, 13.0f, 9.0f, 13.0f)
                verticalLineToRelative(9.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-9.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                verticalLineTo(5.83f)
                lineTo(0.69f, 3.51f)
                lineTo(2.1f, 2.1f)
                lineToRelative(19.8f, 19.8f)
                lineTo(20.49f, 23.31f)
                close()
                moveTo(6.17f, 9.0f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(9.0f)
                horizontalLineTo(6.17f)
                close()
                moveTo(9.0f, 2.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(2.17f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(2.0f)
                close()
                moveTo(13.0f, 9.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(6.17f)
                lineToRelative(1.85f, 1.85f)
                curveTo(12.94f, 9.69f, 13.0f, 9.36f, 13.0f, 9.0f)
                close()
            }
        }
        return _noMeals!!
    }

private var _noMeals: ImageVector? = null
