/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Liquor: ImageVector
    get() {
        if (_liquor != null) {
            return _liquor!!
        }
        _liquor = materialIcon(name = "Sharp.Liquor") {
            materialPath {
                moveTo(3.0f, 14.0f)
                curveToRelative(0.0f, 1.3f, 0.84f, 2.4f, 2.0f, 2.82f)
                verticalLineTo(20.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-3.18f)
                curveTo(8.16f, 16.4f, 9.0f, 15.3f, 9.0f, 14.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(14.0f)
                close()
                moveTo(5.0f, 8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(8.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 9.0f)
                lineToRelative(-3.0f, -1.01f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(6.0f)
                lineToRelative(-3.0f, 1.01f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(11.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(16.0f, 4.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(13.0f, 10.44f)
                lineToRelative(3.0f, -0.98f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.46f)
                lineToRelative(3.0f, 0.98f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(-7.0f)
                verticalLineTo(10.44f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-7.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(7.0f)
                verticalLineTo(20.0f)
                close()
            }
        }
        return _liquor!!
    }

private var _liquor: ImageVector? = null
