/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.QuestionMark: ImageVector
    get() {
        if (_questionMark != null) {
            return _questionMark!!
        }
        _questionMark = materialIcon(name = "Rounded.QuestionMark") {
            materialPath {
                moveTo(7.92f, 7.54f)
                curveTo(7.12f, 7.2f, 6.78f, 6.21f, 7.26f, 5.49f)
                curveTo(8.23f, 4.05f, 9.85f, 3.0f, 11.99f, 3.0f)
                curveToRelative(2.35f, 0.0f, 3.96f, 1.07f, 4.78f, 2.41f)
                curveToRelative(0.7f, 1.15f, 1.11f, 3.3f, 0.03f, 4.9f)
                curveToRelative(-1.2f, 1.77f, -2.35f, 2.31f, -2.97f, 3.45f)
                curveToRelative(-0.15f, 0.27f, -0.24f, 0.49f, -0.3f, 0.94f)
                curveToRelative(-0.09f, 0.73f, -0.69f, 1.3f, -1.43f, 1.3f)
                curveToRelative(-0.87f, 0.0f, -1.58f, -0.75f, -1.48f, -1.62f)
                curveToRelative(0.06f, -0.51f, 0.18f, -1.04f, 0.46f, -1.54f)
                curveToRelative(0.77f, -1.39f, 2.25f, -2.21f, 3.11f, -3.44f)
                curveToRelative(0.91f, -1.29f, 0.4f, -3.7f, -2.18f, -3.7f)
                curveToRelative(-1.17f, 0.0f, -1.93f, 0.61f, -2.4f, 1.34f)
                curveTo(9.26f, 7.61f, 8.53f, 7.79f, 7.92f, 7.54f)
                close()
                moveTo(14.0f, 20.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveTo(14.0f, 18.9f, 14.0f, 20.0f)
                close()
            }
        }
        return _questionMark!!
    }

private var _questionMark: ImageVector? = null
