/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Cyclone: ImageVector
    get() {
        if (_cyclone != null) {
            return _cyclone!!
        }
        _cyclone = materialIcon(name = "Rounded.Cyclone") {
            materialPath {
                moveTo(12.0f, 8.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                curveTo(16.0f, 9.79f, 14.21f, 8.0f, 12.0f, 8.0f)
                close()
                moveTo(12.0f, 14.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(14.0f, 13.1f, 13.1f, 14.0f, 12.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 6.11f)
                lineTo(22.0f, 6.11f)
                curveToRelative(0.0f, -0.46f, -0.3f, -0.86f, -0.74f, -0.97f)
                curveTo(19.23f, 4.6f, 16.03f, 4.0f, 12.0f, 4.0f)
                curveTo(9.85f, 4.0f, 7.89f, 4.86f, 6.46f, 6.24f)
                curveToRelative(0.1f, -0.65f, 0.28f, -1.69f, 0.62f, -2.96f)
                curveTo(7.25f, 2.64f, 6.78f, 2.0f, 6.11f, 2.0f)
                horizontalLineToRelative(0.0f)
                curveTo(5.66f, 2.0f, 5.26f, 2.3f, 5.14f, 2.74f)
                curveTo(4.6f, 4.77f, 4.0f, 7.97f, 4.0f, 12.0f)
                curveToRelative(0.0f, 2.15f, 0.86f, 4.11f, 2.24f, 5.54f)
                curveToRelative(-0.65f, -0.1f, -1.69f, -0.28f, -2.96f, -0.62f)
                curveTo(2.64f, 16.75f, 2.0f, 17.22f, 2.0f, 17.89f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.46f, 0.3f, 0.86f, 0.74f, 0.97f)
                curveTo(4.77f, 19.4f, 7.97f, 20.0f, 12.0f, 20.0f)
                curveToRelative(2.15f, 0.0f, 4.11f, -0.86f, 5.54f, -2.24f)
                curveToRelative(-0.1f, 0.65f, -0.28f, 1.69f, -0.62f, 2.96f)
                curveToRelative(-0.17f, 0.64f, 0.3f, 1.28f, 0.97f, 1.28f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.46f, 0.0f, 0.86f, -0.3f, 0.97f, -0.74f)
                curveTo(19.4f, 19.23f, 20.0f, 16.03f, 20.0f, 12.0f)
                curveToRelative(0.0f, -2.15f, -0.86f, -4.11f, -2.24f, -5.54f)
                curveToRelative(0.65f, 0.1f, 1.69f, 0.28f, 2.96f, 0.62f)
                curveTo(21.36f, 7.25f, 22.0f, 6.78f, 22.0f, 6.11f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-3.31f, 0.0f, -6.0f, -2.69f, -6.0f, -6.0f)
                reflectiveCurveToRelative(2.69f, -6.0f, 6.0f, -6.0f)
                reflectiveCurveToRelative(6.0f, 2.69f, 6.0f, 6.0f)
                reflectiveCurveTo(15.31f, 18.0f, 12.0f, 18.0f)
                close()
            }
        }
        return _cyclone!!
    }

private var _cyclone: ImageVector? = null
