/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CancelScheduleSend: ImageVector
    get() {
        if (_cancelScheduleSend != null) {
            return _cancelScheduleSend!!
        }
        _cancelScheduleSend = materialIcon(name = "Rounded.CancelScheduleSend") {
            materialPath {
                moveTo(16.5f, 9.0f)
                curveToRelative(-0.42f, 0.0f, -0.83f, 0.04f, -1.24f, 0.11f)
                lineTo(2.4f, 3.6f)
                curveTo(1.74f, 3.31f, 1.01f, 3.8f, 1.01f, 4.51f)
                lineTo(1.0f, 9.2f)
                curveToRelative(0.0f, 0.47f, 0.33f, 0.88f, 0.78f, 0.98f)
                lineTo(10.0f, 12.0f)
                lineToRelative(-8.22f, 1.83f)
                curveTo(1.33f, 13.93f, 1.0f, 14.33f, 1.0f, 14.8f)
                lineToRelative(0.01f, 4.68f)
                curveToRelative(0.0f, 0.72f, 0.73f, 1.2f, 1.39f, 0.92f)
                lineToRelative(6.68f, -2.86f)
                curveTo(9.59f, 21.19f, 12.71f, 24.0f, 16.5f, 24.0f)
                curveToRelative(4.14f, 0.0f, 7.5f, -3.36f, 7.5f, -7.5f)
                reflectiveCurveTo(20.64f, 9.0f, 16.5f, 9.0f)
                close()
                moveTo(16.5f, 22.0f)
                curveToRelative(-3.03f, 0.0f, -5.5f, -2.47f, -5.5f, -5.5f)
                reflectiveCurveToRelative(2.47f, -5.5f, 5.5f, -5.5f)
                reflectiveCurveToRelative(5.5f, 2.47f, 5.5f, 5.5f)
                reflectiveCurveTo(19.53f, 22.0f, 16.5f, 22.0f)
                close()
            }
            materialPath {
                moveTo(18.62f, 14.38f)
                curveToRelative(-0.2f, -0.2f, -0.51f, -0.2f, -0.71f, 0.0f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-1.41f, -1.41f)
                curveToRelative(-0.2f, -0.2f, -0.51f, -0.2f, -0.71f, 0.0f)
                reflectiveCurveToRelative(-0.2f, 0.51f, 0.0f, 0.71f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-1.41f, 1.41f)
                curveToRelative(-0.2f, 0.2f, -0.2f, 0.51f, 0.0f, 0.71f)
                curveToRelative(0.2f, 0.2f, 0.51f, 0.2f, 0.71f, 0.0f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(1.41f, 1.41f)
                curveToRelative(0.2f, 0.2f, 0.51f, 0.2f, 0.71f, 0.0f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(1.41f, -1.41f)
                curveTo(18.82f, 14.89f, 18.82f, 14.57f, 18.62f, 14.38f)
                close()
            }
        }
        return _cancelScheduleSend!!
    }

private var _cancelScheduleSend: ImageVector? = null
