/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Unsubscribe: ImageVector
    get() {
        if (_unsubscribe != null) {
            return _unsubscribe!!
        }
        _unsubscribe = materialIcon(name = "Outlined.Unsubscribe") {
            materialPath {
                moveTo(20.99f, 14.04f)
                lineTo(20.99f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.05f)
                curveToRelative(0.28f, 1.92f, 2.1f, 3.35f, 4.18f, 2.93f)
                curveToRelative(1.34f, -0.27f, 2.43f, -1.37f, 2.7f, -2.71f)
                curveToRelative(0.25f, -1.24f, -0.16f, -2.39f, -0.94f, -3.18f)
                close()
                moveTo(18.99f, 5.0f)
                lineTo(12.0f, 8.5f)
                lineTo(5.0f, 5.0f)
                horizontalLineToRelative(13.99f)
                close()
                moveTo(15.35f, 15.0f)
                lineTo(5.0f, 15.0f)
                lineTo(5.0f, 7.0f)
                lineToRelative(7.0f, 3.5f)
                lineTo(19.0f, 7.0f)
                verticalLineToRelative(6.05f)
                curveToRelative(-0.16f, -0.02f, -0.33f, -0.05f, -0.5f, -0.05f)
                curveToRelative(-1.39f, 0.0f, -2.59f, 0.82f, -3.15f, 2.0f)
                close()
                moveTo(20.5f, 17.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(1.0f)
                close()
            }
        }
        return _unsubscribe!!
    }

private var _unsubscribe: ImageVector? = null
