/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.AutofpsSelect: ImageVector
    get() {
        if (_autofpsSelect != null) {
            return _autofpsSelect!!
        }
        _autofpsSelect = materialIcon(name = "Outlined.AutofpsSelect") {
            materialPath {
                moveTo(12.03f, 6.3f)
                lineToRelative(-0.06f, 0.0f)
                lineToRelative(-1.02f, 2.89f)
                lineToRelative(2.1f, 0.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 17.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 15.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, -2.69f, 6.0f, -6.0f)
                reflectiveCurveToRelative(-2.69f, -6.0f, -6.0f, -6.0f)
                reflectiveCurveTo(6.0f, 5.69f, 6.0f, 9.0f)
                reflectiveCurveTo(8.69f, 15.0f, 12.0f, 15.0f)
                close()
                moveTo(11.37f, 5.0f)
                horizontalLineToRelative(1.25f)
                lineToRelative(2.63f, 7.0f)
                horizontalLineToRelative(-1.21f)
                lineToRelative(-0.63f, -1.79f)
                horizontalLineToRelative(-2.83f)
                lineTo(9.96f, 12.0f)
                horizontalLineTo(8.74f)
                lineTo(11.37f, 5.0f)
                close()
            }
            materialPath {
                moveTo(7.0f, 17.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 17.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 17.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
        }
        return _autofpsSelect!!
    }

private var _autofpsSelect: ImageVector? = null
