/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Person4: ImageVector
    get() {
        if (_person4 != null) {
            return _person4!!
        }
        _person4 = materialIcon(name = "TwoTone.Person4") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.5f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(8.0f)
                curveTo(10.0f, 9.1f, 10.9f, 10.0f, 12.0f, 10.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.48f, 16.34f)
                curveTo(16.29f, 15.73f, 14.37f, 15.0f, 12.0f, 15.0f)
                curveToRelative(-2.37f, 0.0f, -4.29f, 0.73f, -5.48f, 1.34f)
                curveTo(6.2f, 16.5f, 6.0f, 16.84f, 6.0f, 17.22f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-0.78f)
                curveTo(18.0f, 16.84f, 17.8f, 16.5f, 17.48f, 16.34f)
                close()
            }
            materialPath {
                moveTo(18.39f, 14.56f)
                curveTo(16.71f, 13.7f, 14.53f, 13.0f, 12.0f, 13.0f)
                curveToRelative(-2.53f, 0.0f, -4.71f, 0.7f, -6.39f, 1.56f)
                curveTo(4.61f, 15.07f, 4.0f, 16.1f, 4.0f, 17.22f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.78f)
                curveTo(20.0f, 16.1f, 19.39f, 15.07f, 18.39f, 14.56f)
                close()
                moveTo(18.0f, 18.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-0.78f)
                curveToRelative(0.0f, -0.38f, 0.2f, -0.72f, 0.52f, -0.88f)
                curveTo(7.71f, 15.73f, 9.63f, 15.0f, 12.0f, 15.0f)
                curveToRelative(2.37f, 0.0f, 4.29f, 0.73f, 5.48f, 1.34f)
                curveTo(17.8f, 16.5f, 18.0f, 16.84f, 18.0f, 17.22f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                curveToRelative(0.0f, -1.37f, 0.0f, -3.5f, 0.0f, -3.5f)
                curveTo(16.0f, 3.67f, 15.33f, 3.0f, 14.5f, 3.0f)
                curveToRelative(-0.52f, 0.0f, -0.98f, 0.27f, -1.25f, 0.67f)
                curveTo(12.98f, 3.27f, 12.52f, 3.0f, 12.0f, 3.0f)
                reflectiveCurveToRelative(-0.98f, 0.27f, -1.25f, 0.67f)
                curveTo(10.48f, 3.27f, 10.02f, 3.0f, 9.5f, 3.0f)
                curveTo(8.67f, 3.0f, 8.0f, 3.67f, 8.0f, 4.5f)
                curveToRelative(0.0f, 0.0f, 0.0f, 2.12f, 0.0f, 3.5f)
                curveTo(8.0f, 10.21f, 9.79f, 12.0f, 12.0f, 12.0f)
                close()
                moveTo(10.0f, 5.5f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(5.5f)
                close()
            }
        }
        return _person4!!
    }

private var _person4: ImageVector? = null
