/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Medication: ImageVector
    get() {
        if (_medication != null) {
            return _medication!!
        }
        _medication = materialIcon(name = "TwoTone.Medication") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.0f, 19.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(8.0f, 12.0f)
                horizontalLineToRelative(2.5f)
                verticalLineTo(9.5f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(12.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.5f)
                verticalLineToRelative(2.5f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(15.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(12.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 3.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-12.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 6.0f)
                horizontalLineTo(7.0f)
                curveTo(5.9f, 6.0f, 5.0f, 6.9f, 5.0f, 8.0f)
                verticalLineToRelative(11.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(8.0f)
                curveTo(19.0f, 6.9f, 18.1f, 6.0f, 17.0f, 6.0f)
                close()
                moveTo(17.0f, 19.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(10.5f, 17.5f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, -2.5f)
                lineToRelative(2.5f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(-2.5f, 0.0f)
                lineToRelative(0.0f, -2.5f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, 2.5f)
                lineToRelative(-2.5f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(2.5f, 0.0f)
                close()
            }
        }
        return _medication!!
    }

private var _medication: ImageVector? = null
