/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.InstallDesktop: ImageVector
    get() {
        if (_installDesktop != null) {
            return _installDesktop!!
        }
        _installDesktop = materialIcon(name = "TwoTone.InstallDesktop") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.83f, 9.0f)
                lineToRelative(0.0f, 0.0f)
                lineToRelative(1.17f, 1.17f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 17.0f)
                lineToRelative(16.0f, 0.0f)
                lineToRelative(0.0f, -3.17f)
                lineToRelative(-3.0f, 3.0f)
                lineToRelative(-7.83f, -7.83f)
                lineToRelative(3.83f, -3.83f)
                lineToRelative(0.0f, -0.17f)
                lineToRelative(-9.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 17.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(9.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(4.0f)
                curveTo(2.89f, 3.0f, 2.0f, 3.89f, 2.0f, 5.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-5.17f)
                lineToRelative(-2.0f, 2.0f)
                verticalLineTo(17.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 10.17f)
                lineToRelative(0.0f, -7.17f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 7.17f)
                lineToRelative(-2.59f, -2.58f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(5.0f, 5.0f)
                lineToRelative(5.0f, -5.0f)
                lineToRelative(-1.41f, -1.41f)
                close()
            }
        }
        return _installDesktop!!
    }

private var _installDesktop: ImageVector? = null
