/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.HistoryEdu: ImageVector
    get() {
        if (_historyEdu != null) {
            return _historyEdu!!
        }
        _historyEdu = materialIcon(name = "TwoTone.HistoryEdu") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.34f, 9.76f)
                lineTo(9.93f, 8.34f)
                curveTo(8.98f, 7.4f, 7.73f, 6.88f, 6.39f, 6.88f)
                curveTo(5.76f, 6.88f, 5.14f, 7.0f, 4.57f, 7.22f)
                lineToRelative(1.04f, 1.04f)
                horizontalLineToRelative(2.28f)
                verticalLineToRelative(2.14f)
                curveToRelative(0.4f, 0.23f, 0.86f, 0.35f, 1.33f, 0.35f)
                curveToRelative(0.73f, 0.0f, 1.41f, -0.28f, 1.92f, -0.8f)
                lineTo(11.34f, 9.76f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.0f, 6.62f)
                lineToRelative(6.0f, 5.97f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(-1.41f)
                lineToRelative(-2.83f, -2.83f)
                lineToRelative(-0.2f, 0.2f)
                curveToRelative(-0.46f, 0.46f, -0.99f, 0.8f, -1.56f, 1.03f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineTo(6.62f)
                close()
            }
            materialPath {
                moveTo(9.0f, 4.0f)
                verticalLineToRelative(1.38f)
                curveToRelative(-0.83f, -0.33f, -1.72f, -0.5f, -2.61f, -0.5f)
                curveToRelative(-1.79f, 0.0f, -3.58f, 0.68f, -4.95f, 2.05f)
                lineToRelative(3.33f, 3.33f)
                horizontalLineToRelative(1.11f)
                verticalLineToRelative(1.11f)
                curveToRelative(0.86f, 0.86f, 1.98f, 1.31f, 3.11f, 1.36f)
                verticalLineTo(15.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(9.0f)
                close()
                moveTo(7.89f, 10.41f)
                verticalLineTo(8.26f)
                horizontalLineTo(5.61f)
                lineTo(4.57f, 7.22f)
                curveTo(5.14f, 7.0f, 5.76f, 6.88f, 6.39f, 6.88f)
                curveToRelative(1.34f, 0.0f, 2.59f, 0.52f, 3.54f, 1.46f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-0.2f, 0.2f)
                curveToRelative(-0.51f, 0.51f, -1.19f, 0.8f, -1.92f, 0.8f)
                curveTo(8.75f, 10.75f, 8.29f, 10.63f, 7.89f, 10.41f)
                close()
                moveTo(19.0f, 17.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(-2.59f)
                curveToRelative(0.57f, -0.23f, 1.1f, -0.57f, 1.56f, -1.03f)
                lineToRelative(0.2f, -0.2f)
                lineTo(15.59f, 14.0f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(-1.41f)
                lineToRelative(-6.0f, -5.97f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(17.0f)
                close()
            }
        }
        return _historyEdu!!
    }

private var _historyEdu: ImageVector? = null
