/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.EditAttributes: ImageVector
    get() {
        if (_editAttributes != null) {
            return _editAttributes!!
        }
        _editAttributes = materialIcon(name = "TwoTone.EditAttributes") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.63f, 9.0f)
                horizontalLineTo(6.37f)
                curveTo(5.09f, 9.0f, 4.0f, 10.37f, 4.0f, 12.0f)
                reflectiveCurveToRelative(1.09f, 3.0f, 2.37f, 3.0f)
                horizontalLineToRelative(11.26f)
                curveToRelative(1.28f, 0.0f, 2.37f, -1.37f, 2.37f, -3.0f)
                reflectiveCurveToRelative(-1.09f, -3.0f, -2.37f, -3.0f)
                close()
                moveTo(7.24f, 14.46f)
                lineToRelative(-2.57f, -2.57f)
                lineToRelative(0.7f, -0.7f)
                lineToRelative(1.87f, 1.87f)
                lineToRelative(3.52f, -3.52f)
                lineToRelative(0.7f, 0.7f)
                lineToRelative(-4.22f, 4.22f)
                close()
            }
            materialPath {
                moveTo(17.63f, 7.0f)
                lineTo(6.37f, 7.0f)
                curveTo(3.96f, 7.0f, 2.0f, 9.24f, 2.0f, 12.0f)
                reflectiveCurveToRelative(1.96f, 5.0f, 4.37f, 5.0f)
                horizontalLineToRelative(11.26f)
                curveToRelative(2.41f, 0.0f, 4.37f, -2.24f, 4.37f, -5.0f)
                reflectiveCurveToRelative(-1.96f, -5.0f, -4.37f, -5.0f)
                close()
                moveTo(17.63f, 15.0f)
                lineTo(6.37f, 15.0f)
                curveTo(5.09f, 15.0f, 4.0f, 13.63f, 4.0f, 12.0f)
                reflectiveCurveToRelative(1.09f, -3.0f, 2.37f, -3.0f)
                horizontalLineToRelative(11.26f)
                curveTo(18.91f, 9.0f, 20.0f, 10.37f, 20.0f, 12.0f)
                reflectiveCurveToRelative(-1.09f, 3.0f, -2.37f, 3.0f)
                close()
                moveTo(7.24f, 13.06f)
                lineToRelative(-1.87f, -1.87f)
                lineToRelative(-0.7f, 0.7f)
                lineToRelative(2.57f, 2.57f)
                lineToRelative(4.22f, -4.22f)
                lineToRelative(-0.7f, -0.7f)
                close()
            }
        }
        return _editAttributes!!
    }

private var _editAttributes: ImageVector? = null
