/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp._4k: ImageVector
    get() {
        if (__4k != null) {
            return __4k!!
        }
        __4k = materialIcon(name = "Sharp._4k") {
            materialPath {
                moveTo(21.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(18.0f)
                lineTo(21.0f, 3.0f)
                close()
                moveTo(12.0f, 13.51f)
                horizontalLineToRelative(-1.0f)
                lineTo(11.0f, 15.0f)
                lineTo(9.5f, 15.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(-3.0f)
                lineTo(6.5f, 9.0f)
                lineTo(8.0f, 9.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(1.5f)
                lineTo(9.5f, 9.0f)
                lineTo(11.0f, 9.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.51f)
                close()
                moveTo(18.2f, 15.0f)
                horizontalLineToRelative(-1.7f)
                lineToRelative(-2.0f, -3.0f)
                verticalLineToRelative(3.0f)
                lineTo(13.0f, 15.0f)
                lineTo(13.0f, 9.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.0f, -3.0f)
                horizontalLineToRelative(1.7f)
                lineToRelative(-2.0f, 3.0f)
                lineToRelative(2.0f, 3.0f)
                close()
            }
        }
        return __4k!!
    }

private var __4k: ImageVector? = null
