/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.StrikethroughS: ImageVector
    get() {
        if (_strikethroughS != null) {
            return _strikethroughS!!
        }
        _strikethroughS = materialIcon(name = "Sharp.StrikethroughS") {
            materialPath {
                moveTo(7.24f, 8.75f)
                curveToRelative(-0.26f, -0.48f, -0.39f, -1.03f, -0.39f, -1.67f)
                curveToRelative(0.0f, -0.61f, 0.13f, -1.16f, 0.4f, -1.67f)
                curveToRelative(0.26f, -0.5f, 0.63f, -0.93f, 1.11f, -1.29f)
                curveToRelative(0.48f, -0.35f, 1.05f, -0.63f, 1.7f, -0.83f)
                curveToRelative(0.66f, -0.19f, 1.39f, -0.29f, 2.18f, -0.29f)
                curveToRelative(0.81f, 0.0f, 1.54f, 0.11f, 2.21f, 0.34f)
                curveToRelative(0.66f, 0.22f, 1.23f, 0.54f, 1.69f, 0.94f)
                curveToRelative(0.47f, 0.4f, 0.83f, 0.88f, 1.08f, 1.43f)
                reflectiveCurveToRelative(0.38f, 1.15f, 0.38f, 1.81f)
                horizontalLineToRelative(-3.01f)
                curveToRelative(0.0f, -0.31f, -0.05f, -0.59f, -0.15f, -0.85f)
                curveToRelative(-0.09f, -0.27f, -0.24f, -0.49f, -0.44f, -0.68f)
                curveToRelative(-0.2f, -0.19f, -0.45f, -0.33f, -0.75f, -0.44f)
                curveToRelative(-0.3f, -0.1f, -0.66f, -0.16f, -1.06f, -0.16f)
                curveToRelative(-0.39f, 0.0f, -0.74f, 0.04f, -1.03f, 0.13f)
                reflectiveCurveToRelative(-0.53f, 0.21f, -0.72f, 0.36f)
                curveToRelative(-0.19f, 0.16f, -0.34f, 0.34f, -0.44f, 0.55f)
                curveToRelative(-0.1f, 0.21f, -0.15f, 0.43f, -0.15f, 0.66f)
                curveToRelative(0.0f, 0.48f, 0.25f, 0.88f, 0.74f, 1.21f)
                curveToRelative(0.38f, 0.25f, 0.77f, 0.48f, 1.41f, 0.7f)
                horizontalLineTo(7.39f)
                curveToRelative(-0.05f, -0.08f, -0.11f, -0.17f, -0.15f, -0.25f)
                close()
                moveTo(21.0f, 12.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(9.62f)
                curveToRelative(0.18f, 0.07f, 0.4f, 0.14f, 0.55f, 0.2f)
                curveToRelative(0.37f, 0.17f, 0.66f, 0.34f, 0.87f, 0.51f)
                reflectiveCurveToRelative(0.35f, 0.36f, 0.43f, 0.57f)
                curveToRelative(0.07f, 0.2f, 0.11f, 0.43f, 0.11f, 0.69f)
                curveToRelative(0.0f, 0.23f, -0.05f, 0.45f, -0.14f, 0.66f)
                curveToRelative(-0.09f, 0.2f, -0.23f, 0.38f, -0.42f, 0.53f)
                curveToRelative(-0.19f, 0.15f, -0.42f, 0.26f, -0.71f, 0.35f)
                curveToRelative(-0.29f, 0.08f, -0.63f, 0.13f, -1.01f, 0.13f)
                curveToRelative(-0.43f, 0.0f, -0.83f, -0.04f, -1.18f, -0.13f)
                reflectiveCurveToRelative(-0.66f, -0.23f, -0.91f, -0.42f)
                curveToRelative(-0.25f, -0.19f, -0.45f, -0.44f, -0.59f, -0.75f)
                reflectiveCurveToRelative(-0.25f, -0.76f, -0.25f, -1.21f)
                horizontalLineTo(6.4f)
                curveToRelative(0.0f, 0.55f, 0.08f, 1.13f, 0.24f, 1.58f)
                reflectiveCurveToRelative(0.37f, 0.85f, 0.65f, 1.21f)
                curveToRelative(0.28f, 0.35f, 0.6f, 0.66f, 0.98f, 0.92f)
                curveToRelative(0.37f, 0.26f, 0.78f, 0.48f, 1.22f, 0.65f)
                curveToRelative(0.44f, 0.17f, 0.9f, 0.3f, 1.38f, 0.39f)
                curveToRelative(0.48f, 0.08f, 0.96f, 0.13f, 1.44f, 0.13f)
                curveToRelative(0.8f, 0.0f, 1.53f, -0.09f, 2.18f, -0.28f)
                reflectiveCurveToRelative(1.21f, -0.45f, 1.67f, -0.79f)
                curveToRelative(0.46f, -0.34f, 0.82f, -0.77f, 1.07f, -1.27f)
                reflectiveCurveToRelative(0.38f, -1.07f, 0.38f, -1.71f)
                curveToRelative(0.0f, -0.6f, -0.1f, -1.14f, -0.31f, -1.61f)
                curveToRelative(-0.05f, -0.11f, -0.11f, -0.23f, -0.17f, -0.33f)
                horizontalLineTo(21.0f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _strikethroughS!!
    }

private var _strikethroughS: ImageVector? = null
