/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Reviews: ImageVector
    get() {
        if (_reviews != null) {
            return _reviews!!
        }
        _reviews = materialIcon(name = "Sharp.Reviews") {
            materialPath {
                moveTo(22.0f, 2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(20.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(2.0f)
                close()
                moveTo(13.57f, 11.57f)
                lineTo(12.0f, 15.0f)
                lineToRelative(-1.57f, -3.43f)
                lineTo(7.0f, 10.0f)
                lineToRelative(3.43f, -1.57f)
                lineTo(12.0f, 5.0f)
                lineToRelative(1.57f, 3.43f)
                lineTo(17.0f, 10.0f)
                lineTo(13.57f, 11.57f)
                close()
            }
        }
        return _reviews!!
    }

private var _reviews: ImageVector? = null
