/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Plumbing: ImageVector
    get() {
        if (_plumbing != null) {
            return _plumbing!!
        }
        _plumbing = materialIcon(name = "Sharp.Plumbing") {
            materialPath {
                moveTo(16.16f, 5.64f)
                lineToRelative(3.54f, 3.54f)
                curveToRelative(1.17f, -1.17f, 1.17f, -3.07f, 0.0f, -4.24f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(-4.24f, 4.24f)
                lineToRelative(2.12f, 2.12f)
                lineTo(16.16f, 5.64f)
                close()
            }
            materialPath {
                moveTo(4.842f, 12.708f)
                lineToRelative(3.535f, -3.535f)
                lineToRelative(2.121f, 2.121f)
                lineToRelative(-3.535f, 3.535f)
                close()
            }
            materialPath {
                moveTo(15.45f, 7.76f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(9.79f, 4.93f)
                lineTo(7.67f, 7.05f)
                lineToRelative(4.24f, 4.24f)
                lineToRelative(-8.49f, 8.49f)
                lineToRelative(2.83f, 2.83f)
                lineTo(16.86f, 12.0f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(1.41f, -1.41f)
                lineTo(15.45f, 7.76f)
                close()
            }
        }
        return _plumbing!!
    }

private var _plumbing: ImageVector? = null
