/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PanoramaWideAngleSelect: ImageVector
    get() {
        if (_panoramaWideAngleSelect != null) {
            return _panoramaWideAngleSelect!!
        }
        _panoramaWideAngleSelect = materialIcon(name = "Sharp.PanoramaWideAngleSelect") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveTo(8.03f, 4.0f, 5.15f, 4.63f, 3.0f, 5.0f)
                curveToRelative(-0.55f, 1.97f, -1.0f, 3.92f, -1.0f, 7.0f)
                curveToRelative(0.0f, 3.03f, 0.45f, 5.05f, 1.0f, 7.0f)
                curveToRelative(2.15f, 0.37f, 4.98f, 1.0f, 9.0f, 1.0f)
                curveToRelative(3.97f, 0.0f, 6.85f, -0.63f, 9.0f, -1.0f)
                curveToRelative(0.57f, -2.02f, 1.0f, -3.99f, 1.0f, -7.0f)
                curveToRelative(0.0f, -3.03f, -0.45f, -5.05f, -1.0f, -7.0f)
                curveTo(18.85f, 4.63f, 16.02f, 4.0f, 12.0f, 4.0f)
                close()
            }
        }
        return _panoramaWideAngleSelect!!
    }

private var _panoramaWideAngleSelect: ImageVector? = null
