/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NestCamWiredStand: ImageVector
    get() {
        if (_nestCamWiredStand != null) {
            return _nestCamWiredStand!!
        }
        _nestCamWiredStand = materialIcon(name = "Sharp.NestCamWiredStand") {
            materialPath {
                moveTo(18.0f, 0.85f)
                lineTo(11.98f, 1.4f)
                curveTo(8.95f, 1.7f, 6.37f, 4.0f, 6.04f, 7.03f)
                curveToRelative(-0.39f, 3.57f, 2.2f, 6.69f, 5.68f, 7.04f)
                lineToRelative(1.9f, 0.19f)
                lineToRelative(-0.56f, 0.85f)
                curveToRelative(-0.88f, -0.19f, -1.83f, -0.18f, -2.85f, 0.25f)
                curveTo(8.21f, 16.21f, 7.0f, 18.25f, 7.0f, 20.41f)
                lineTo(7.0f, 23.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -1.67f, -0.83f, -3.15f, -2.09f, -4.06f)
                lineToRelative(0.97f, -1.45f)
                lineTo(18.0f, 14.72f)
                verticalLineTo(0.85f)
                close()
            }
        }
        return _nestCamWiredStand!!
    }

private var _nestCamWiredStand: ImageVector? = null
