/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DisplaySettings: ImageVector
    get() {
        if (_displaySettings != null) {
            return _displaySettings!!
        }
        _displaySettings = materialIcon(name = "Sharp.DisplaySettings") {
            materialPath {
                moveTo(22.0f, 3.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(3.0f)
                close()
                moveTo(20.0f, 17.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(17.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 8.25f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-8.0f)
                close()
            }
            materialPath {
                moveTo(16.5f, 9.75f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -1.5f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, -1.25f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(1.5f, 0.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 12.25f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-8.0f)
                close()
            }
            materialPath {
                moveTo(7.5f, 15.0f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -4.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 1.25f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 1.5f)
                lineToRelative(1.5f, 0.0f)
                close()
            }
        }
        return _displaySettings!!
    }

private var _displaySettings: ImageVector? = null
