/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Celebration: ImageVector
    get() {
        if (_celebration != null) {
            return _celebration!!
        }
        _celebration = materialIcon(name = "Sharp.Celebration") {
            materialPath {
                moveTo(2.0f, 22.0f)
                lineToRelative(14.0f, -5.0f)
                lineToRelative(-9.0f, -9.0f)
                close()
            }
            materialPath {
                moveTo(14.53f, 12.53f)
                lineTo(21.0f, 6.05f)
                lineToRelative(1.48f, 1.48f)
                lineToRelative(1.06f, -1.06f)
                lineTo(21.0f, 3.93f)
                lineToRelative(-7.53f, 7.53f)
                lineTo(14.53f, 12.53f)
                close()
            }
            materialPath {
                moveTo(10.94f, 6.0f)
                lineTo(9.47f, 7.47f)
                lineToRelative(1.06f, 1.06f)
                lineToRelative(2.54f, -2.54f)
                lineToRelative(-2.54f, -2.53f)
                lineTo(9.47f, 4.53f)
                lineTo(10.94f, 6.0f)
                close()
            }
            materialPath {
                moveTo(18.97f, 9.97f)
                lineToRelative(-3.5f, 3.5f)
                lineToRelative(1.06f, 1.06f)
                lineTo(19.0f, 12.06f)
                lineToRelative(2.5f, 2.49f)
                lineToRelative(1.06f, -1.06f)
                lineTo(18.97f, 9.97f)
                close()
            }
            materialPath {
                moveTo(15.97f, 4.97f)
                lineToRelative(-4.5f, 4.5f)
                lineToRelative(1.06f, 1.06f)
                lineTo(18.07f, 5.0f)
                lineToRelative(-3.53f, -3.53f)
                lineToRelative(-1.06f, 1.06f)
                lineTo(15.97f, 4.97f)
                close()
            }
        }
        return _celebration!!
    }

private var _celebration: ImageVector? = null
