/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BrunchDining: ImageVector
    get() {
        if (_brunchDining != null) {
            return _brunchDining!!
        }
        _brunchDining = materialIcon(name = "Sharp.BrunchDining") {
            materialPath {
                moveTo(18.0f, 8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(8.0f)
                close()
                moveTo(16.0f, 22.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(22.0f)
                close()
                moveTo(18.0f, 15.89f)
                lineToRelative(-0.4f, -0.42f)
                curveToRelative(-1.02f, -1.08f, -1.6f, -2.52f, -1.6f, -4.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(9.51f)
                curveToRelative(0.0f, 1.46f, -0.54f, 2.87f, -1.53f, 3.94f)
                lineTo(20.0f, 15.97f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(15.89f)
                close()
                moveTo(7.0f, 16.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(7.0f)
                close()
            }
        }
        return _brunchDining!!
    }

private var _brunchDining: ImageVector? = null
