/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AssistWalker: ImageVector
    get() {
        if (_assistWalker != null) {
            return _assistWalker!!
        }
        _assistWalker = materialIcon(name = "Sharp.AssistWalker") {
            materialPath {
                moveTo(12.5f, 4.5f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(19.77f, 17.72f)
                lineTo(19.0f, 10.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-1.5f, -0.02f, -2.86f, -0.54f, -3.76f, -1.44f)
                lineToRelative(-2.0f, -1.98f)
                curveTo(10.08f, 6.42f, 9.62f, 6.0f, 8.83f, 6.0f)
                curveTo(8.32f, 6.0f, 7.81f, 6.2f, 7.42f, 6.59f)
                lineToRelative(-4.2f, 4.17f)
                lineToRelative(2.08f, 4.07f)
                lineToRelative(-3.15f, 4.05f)
                lineToRelative(1.57f, 1.24f)
                lineToRelative(3.68f, -4.73f)
                lineToRelative(-0.17f, -1.36f)
                lineTo(8.0f, 14.75f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-6.12f)
                lineToRelative(-2.12f, -2.12f)
                lineToRelative(2.36f, -2.36f)
                curveToRelative(0.94f, 0.94f, 1.72f, 1.82f, 3.59f, 2.32f)
                lineTo(13.0f, 20.0f)
                horizontalLineToRelative(1.5f)
                lineToRelative(0.41f, -3.5f)
                horizontalLineToRelative(3.18f)
                lineToRelative(0.14f, 1.22f)
                curveToRelative(-0.44f, 0.26f, -0.73f, 0.74f, -0.73f, 1.28f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveToRelative(1.5f, -0.67f, 1.5f, -1.5f)
                curveTo(20.5f, 18.46f, 20.21f, 17.98f, 19.77f, 17.72f)
                close()
                moveTo(15.09f, 15.0f)
                lineToRelative(0.41f, -3.5f)
                horizontalLineToRelative(2.0f)
                lineToRelative(0.41f, 3.5f)
                horizontalLineTo(15.09f)
                close()
            }
        }
        return _assistWalker!!
    }

private var _assistWalker: ImageVector? = null
