/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AirlineSeatLegroomExtra: ImageVector
    get() {
        if (_airlineSeatLegroomExtra != null) {
            return _airlineSeatLegroomExtra!!
        }
        _airlineSeatLegroomExtra = materialIcon(name = "Sharp.AirlineSeatLegroomExtra") {
            materialPath {
                moveTo(4.0f, 3.0f)
                lineTo(2.0f, 3.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(-2.0f)
                lineTo(4.0f, 15.0f)
                close()
                moveTo(22.24f, 15.96f)
                lineToRelative(-2.53f, 1.15f)
                lineToRelative(-3.41f, -6.98f)
                curveTo(15.96f, 9.45f, 15.27f, 9.0f, 14.51f, 9.0f)
                lineTo(11.0f, 9.0f)
                lineTo(11.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(10.0f)
                lineToRelative(3.41f, 7.0f)
                lineToRelative(5.07f, -2.32f)
                lineToRelative(-1.24f, -2.72f)
                close()
            }
        }
        return _airlineSeatLegroomExtra!!
    }

private var _airlineSeatLegroomExtra: ImageVector? = null
