/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ViewComfyAlt: ImageVector
    get() {
        if (_viewComfyAlt != null) {
            return _viewComfyAlt!!
        }
        _viewComfyAlt = materialIcon(name = "Rounded.ViewComfyAlt") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 4.0f, 2.0f, 4.9f, 2.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.9f, 21.1f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(10.5f, 17.0f)
                horizontalLineToRelative(-3.0f)
                curveTo(7.22f, 17.0f, 7.0f, 16.78f, 7.0f, 16.5f)
                verticalLineToRelative(-3.0f)
                curveTo(7.0f, 13.22f, 7.22f, 13.0f, 7.5f, 13.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineToRelative(3.0f)
                curveTo(11.0f, 16.78f, 10.78f, 17.0f, 10.5f, 17.0f)
                close()
                moveTo(10.5f, 11.0f)
                horizontalLineToRelative(-3.0f)
                curveTo(7.22f, 11.0f, 7.0f, 10.78f, 7.0f, 10.5f)
                verticalLineToRelative(-3.0f)
                curveTo(7.0f, 7.22f, 7.22f, 7.0f, 7.5f, 7.0f)
                horizontalLineToRelative(3.0f)
                curveTo(10.78f, 7.0f, 11.0f, 7.22f, 11.0f, 7.5f)
                verticalLineToRelative(3.0f)
                curveTo(11.0f, 10.78f, 10.78f, 11.0f, 10.5f, 11.0f)
                close()
                moveTo(16.5f, 17.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineToRelative(3.0f)
                curveTo(17.0f, 16.78f, 16.78f, 17.0f, 16.5f, 17.0f)
                close()
                moveTo(16.5f, 11.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(-3.0f)
                curveTo(13.0f, 7.22f, 13.22f, 7.0f, 13.5f, 7.0f)
                horizontalLineToRelative(3.0f)
                curveTo(16.78f, 7.0f, 17.0f, 7.22f, 17.0f, 7.5f)
                verticalLineToRelative(3.0f)
                curveTo(17.0f, 10.78f, 16.78f, 11.0f, 16.5f, 11.0f)
                close()
            }
        }
        return _viewComfyAlt!!
    }

private var _viewComfyAlt: ImageVector? = null
