/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Soap: ImageVector
    get() {
        if (_soap != null) {
            return _soap!!
        }
        _soap = materialIcon(name = "Rounded.Soap") {
            materialPath {
                moveTo(14.25f, 6.0f)
                curveTo(14.66f, 6.0f, 15.0f, 6.34f, 15.0f, 6.75f)
                reflectiveCurveTo(14.66f, 7.5f, 14.25f, 7.5f)
                reflectiveCurveTo(13.5f, 7.16f, 13.5f, 6.75f)
                reflectiveCurveTo(13.84f, 6.0f, 14.25f, 6.0f)
                moveTo(14.25f, 4.5f)
                curveTo(13.01f, 4.5f, 12.0f, 5.51f, 12.0f, 6.75f)
                reflectiveCurveTo(13.01f, 9.0f, 14.25f, 9.0f)
                reflectiveCurveToRelative(2.25f, -1.01f, 2.25f, -2.25f)
                reflectiveCurveTo(15.49f, 4.5f, 14.25f, 4.5f)
                lineTo(14.25f, 4.5f)
                close()
                moveTo(20.0f, 5.5f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                reflectiveCurveTo(20.28f, 6.5f, 20.0f, 6.5f)
                reflectiveCurveTo(19.5f, 6.28f, 19.5f, 6.0f)
                reflectiveCurveTo(19.72f, 5.5f, 20.0f, 5.5f)
                moveTo(20.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(21.1f, 4.0f, 20.0f, 4.0f)
                lineTo(20.0f, 4.0f)
                close()
                moveTo(18.0f, 2.5f)
                curveTo(18.0f, 3.33f, 17.33f, 4.0f, 16.5f, 4.0f)
                curveTo(15.67f, 4.0f, 15.0f, 3.33f, 15.0f, 2.5f)
                reflectiveCurveTo(15.67f, 1.0f, 16.5f, 1.0f)
                curveTo(17.33f, 1.0f, 18.0f, 1.67f, 18.0f, 2.5f)
                close()
                moveTo(1.94f, 11.79f)
                curveTo(1.34f, 12.35f, 1.0f, 13.14f, 1.0f, 13.97f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                lineToRelative(13.68f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(12.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                lineToRelative(7.18f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(12.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                lineToRelative(8.18f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(12.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                lineToRelative(6.18f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(8.86f)
                lineToRelative(1.49f, -2.61f)
                curveToRelative(0.09f, -0.16f, 0.14f, -0.33f, 0.14f, -0.53f)
                curveToRelative(0.0f, -0.26f, -0.09f, -0.5f, -0.26f, -0.7f)
                lineTo(9.81f, 5.71f)
                curveTo(9.43f, 5.32f, 8.8f, 5.3f, 8.4f, 5.68f)
                lineTo(1.94f, 11.79f)
                close()
            }
        }
        return _soap!!
    }

private var _soap: ImageVector? = null
