/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Score: ImageVector
    get() {
        if (_score != null) {
            return _score!!
        }
        _score = materialIcon(name = "Rounded.Score") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(12.0f, 5.75f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                reflectiveCurveToRelative(0.75f, 0.34f, 0.75f, 0.75f)
                lineTo(13.5f, 8.0f)
                lineToRelative(1.79f, -2.69f)
                curveToRelative(0.13f, -0.19f, 0.35f, -0.31f, 0.59f, -0.31f)
                curveToRelative(0.56f, 0.0f, 0.9f, 0.63f, 0.59f, 1.1f)
                lineTo(15.2f, 8.0f)
                lineToRelative(1.27f, 1.9f)
                curveToRelative(0.31f, 0.47f, -0.02f, 1.1f, -0.59f, 1.1f)
                curveToRelative(-0.24f, 0.0f, -0.46f, -0.12f, -0.59f, -0.31f)
                lineTo(13.5f, 8.0f)
                verticalLineToRelative(2.25f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                reflectiveCurveToRelative(-0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineToRelative(-4.5f)
                close()
                moveTo(7.0f, 8.25f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(1.5f)
                lineTo(9.5f, 6.5f)
                lineTo(7.75f, 6.5f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                reflectiveCurveTo(7.34f, 5.0f, 7.75f, 5.0f)
                lineTo(10.0f, 5.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.75f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                lineTo(8.5f, 8.75f)
                verticalLineToRelative(0.75f)
                horizontalLineToRelative(1.75f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                reflectiveCurveToRelative(-0.34f, 0.75f, -0.75f, 0.75f)
                lineTo(8.0f, 11.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                lineTo(7.0f, 8.25f)
                close()
                moveTo(18.74f, 13.26f)
                lineToRelative(-5.03f, 5.03f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineTo(9.0f, 15.0f)
                lineToRelative(-2.49f, 2.49f)
                curveToRelative(-0.56f, 0.56f, -1.51f, 0.16f, -1.51f, -0.62f)
                curveToRelative(0.0f, -0.23f, 0.09f, -0.46f, 0.26f, -0.62f)
                lineToRelative(3.03f, -3.03f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineTo(13.0f, 16.5f)
                lineToRelative(4.49f, -4.49f)
                curveToRelative(0.56f, -0.56f, 1.51f, -0.16f, 1.51f, 0.62f)
                curveToRelative(0.0f, 0.24f, -0.09f, 0.46f, -0.26f, 0.63f)
                close()
            }
        }
        return _score!!
    }

private var _score: ImageVector? = null
