/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Router: ImageVector
    get() {
        if (_router != null) {
            return _router!!
        }
        _router = materialIcon(name = "Rounded.Router") {
            materialPath {
                moveTo(11.45f, 5.55f)
                curveToRelative(0.19f, 0.19f, 0.5f, 0.21f, 0.72f, 0.04f)
                curveTo(13.3f, 4.69f, 14.65f, 4.2f, 16.0f, 4.2f)
                reflectiveCurveToRelative(2.7f, 0.49f, 3.84f, 1.39f)
                curveToRelative(0.21f, 0.17f, 0.52f, 0.15f, 0.72f, -0.04f)
                lineToRelative(0.04f, -0.05f)
                curveToRelative(0.22f, -0.22f, 0.21f, -0.59f, -0.03f, -0.8f)
                curveTo(19.24f, 3.57f, 17.62f, 3.0f, 16.0f, 3.0f)
                reflectiveCurveToRelative(-3.24f, 0.57f, -4.57f, 1.7f)
                curveToRelative(-0.24f, 0.21f, -0.26f, 0.57f, -0.03f, 0.8f)
                lineToRelative(0.05f, 0.05f)
                close()
                moveTo(13.15f, 6.31f)
                curveToRelative(-0.25f, 0.2f, -0.26f, 0.58f, -0.04f, 0.8f)
                lineToRelative(0.04f, 0.04f)
                curveToRelative(0.2f, 0.2f, 0.5f, 0.2f, 0.72f, 0.04f)
                curveToRelative(0.63f, -0.48f, 1.38f, -0.69f, 2.13f, -0.69f)
                reflectiveCurveToRelative(1.5f, 0.21f, 2.13f, 0.68f)
                curveToRelative(0.22f, 0.17f, 0.53f, 0.16f, 0.72f, -0.04f)
                lineToRelative(0.04f, -0.04f)
                curveToRelative(0.23f, -0.23f, 0.21f, -0.6f, -0.04f, -0.8f)
                curveToRelative(-0.83f, -0.64f, -1.84f, -1.0f, -2.85f, -1.0f)
                reflectiveCurveToRelative(-2.02f, 0.36f, -2.85f, 1.01f)
                close()
                moveTo(19.0f, 13.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                lineTo(5.0f, 13.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(8.0f, 18.0f)
                lineTo(6.0f, 18.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(11.5f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(15.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
            }
        }
        return _router!!
    }

private var _router: ImageVector? = null
