/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.OnDeviceTraining: ImageVector
    get() {
        if (_onDeviceTraining != null) {
            return _onDeviceTraining!!
        }
        _onDeviceTraining = materialIcon(name = "Rounded.OnDeviceTraining") {
            materialPath {
                moveTo(11.5f, 17.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                lineToRelative(0.0f, 0.0f)
                curveTo(11.0f, 16.78f, 11.22f, 17.0f, 11.5f, 17.0f)
                close()
            }
            materialPath {
                moveTo(11.52f, 11.06f)
                curveToRelative(-0.71f, 0.16f, -1.29f, 0.74f, -1.46f, 1.44f)
                curveToRelative(-0.23f, 0.94f, 0.21f, 1.8f, 0.94f, 2.22f)
                verticalLineToRelative(0.53f)
                curveToRelative(0.0f, 0.14f, 0.11f, 0.25f, 0.25f, 0.25f)
                horizontalLineToRelative(1.5f)
                curveToRelative(0.14f, 0.0f, 0.25f, -0.11f, 0.25f, -0.25f)
                verticalLineToRelative(-0.53f)
                curveToRelative(0.6f, -0.35f, 1.0f, -0.98f, 1.0f, -1.72f)
                curveTo(14.0f, 11.74f, 12.83f, 10.75f, 11.52f, 11.06f)
                close()
            }
            materialPath {
                moveTo(18.0f, 1.01f)
                lineTo(6.0f, 1.0f)
                curveTo(4.9f, 1.0f, 4.0f, 1.9f, 4.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(20.0f, 1.9f, 19.1f, 1.01f, 18.0f, 1.01f)
                close()
                moveTo(18.0f, 18.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(15.33f, 15.27f)
                curveToRelative(0.36f, 0.36f, 0.99f, 0.26f, 1.21f, -0.2f)
                curveTo(16.83f, 14.44f, 17.0f, 13.74f, 17.0f, 13.0f)
                reflectiveCurveToRelative(-0.17f, -1.44f, -0.46f, -2.07f)
                curveToRelative(-0.22f, -0.47f, -0.84f, -0.57f, -1.21f, -0.2f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.22f, 0.22f, -0.28f, 0.56f, -0.15f, 0.84f)
                curveToRelative(0.2f, 0.44f, 0.31f, 0.92f, 0.31f, 1.43f)
                reflectiveCurveToRelative(-0.11f, 0.99f, -0.31f, 1.43f)
                curveTo(15.06f, 14.72f, 15.11f, 15.05f, 15.33f, 15.27f)
                lineTo(15.33f, 15.27f)
                close()
            }
            materialPath {
                moveTo(8.67f, 15.27f)
                curveToRelative(0.22f, -0.22f, 0.28f, -0.56f, 0.15f, -0.84f)
                curveTo(8.61f, 13.99f, 8.5f, 13.51f, 8.5f, 13.0f)
                curveToRelative(0.0f, -1.93f, 1.57f, -3.5f, 3.5f, -3.5f)
                verticalLineToRelative(0.69f)
                curveToRelative(0.0f, 0.22f, 0.25f, 0.33f, 0.42f, 0.19f)
                lineToRelative(1.62f, -1.44f)
                curveToRelative(0.11f, -0.1f, 0.11f, -0.27f, 0.0f, -0.37f)
                lineToRelative(-1.62f, -1.44f)
                curveTo(12.25f, 6.98f, 12.0f, 7.09f, 12.0f, 7.31f)
                verticalLineTo(8.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                curveToRelative(0.0f, 0.74f, 0.17f, 1.44f, 0.46f, 2.07f)
                curveTo(7.68f, 15.54f, 8.3f, 15.64f, 8.67f, 15.27f)
                lineTo(8.67f, 15.27f)
                close()
            }
        }
        return _onDeviceTraining!!
    }

private var _onDeviceTraining: ImageVector? = null
