/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LowPriority: ImageVector
    get() {
        if (_lowPriority != null) {
            return _lowPriority!!
        }
        _lowPriority = materialIcon(name = "Rounded.LowPriority") {
            materialPath {
                moveTo(15.0f, 5.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                close()
                moveTo(15.0f, 10.5f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                close()
                moveTo(15.0f, 16.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                close()
                moveTo(9.85f, 19.15f)
                lineToRelative(1.79f, -1.79f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(-1.79f, -1.79f)
                curveToRelative(-0.31f, -0.32f, -0.85f, -0.1f, -0.85f, 0.35f)
                verticalLineToRelative(3.59f)
                curveToRelative(0.0f, 0.44f, 0.54f, 0.66f, 0.85f, 0.35f)
                close()
                moveTo(9.0f, 16.0f)
                horizontalLineToRelative(-0.3f)
                curveToRelative(-2.35f, 0.0f, -4.45f, -1.71f, -4.68f, -4.05f)
                curveTo(3.76f, 9.27f, 5.87f, 7.0f, 8.5f, 7.0f)
                lineTo(11.0f, 7.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                lineTo(8.5f, 5.0f)
                curveToRelative(-3.86f, 0.0f, -6.96f, 3.4f, -6.44f, 7.36f)
                curveTo(2.48f, 15.64f, 5.43f, 18.0f, 8.73f, 18.0f)
                lineTo(9.0f, 18.0f)
            }
        }
        return _lowPriority!!
    }

private var _lowPriority: ImageVector? = null
