/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LinearScale: ImageVector
    get() {
        if (_linearScale != null) {
            return _linearScale!!
        }
        _linearScale = materialIcon(name = "Rounded.LinearScale") {
            materialPath {
                moveTo(17.0f, 7.0f)
                curveToRelative(-2.41f, 0.0f, -4.43f, 1.72f, -4.9f, 4.0f)
                horizontalLineTo(6.79f)
                curveTo(6.4f, 10.12f, 5.52f, 9.5f, 4.5f, 9.5f)
                curveTo(3.12f, 9.5f, 2.0f, 10.62f, 2.0f, 12.0f)
                reflectiveCurveToRelative(1.12f, 2.5f, 2.5f, 2.5f)
                curveToRelative(1.02f, 0.0f, 1.9f, -0.62f, 2.29f, -1.5f)
                horizontalLineToRelative(5.31f)
                curveToRelative(0.46f, 2.28f, 2.48f, 4.0f, 4.9f, 4.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(19.76f, 7.0f, 17.0f, 7.0f)
                close()
                moveTo(17.0f, 15.0f)
                curveToRelative(-1.65f, 0.0f, -3.0f, -1.35f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.35f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.35f, 3.0f, 3.0f)
                reflectiveCurveTo(18.65f, 15.0f, 17.0f, 15.0f)
                close()
            }
        }
        return _linearScale!!
    }

private var _linearScale: ImageVector? = null
