/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.GridOff: ImageVector
    get() {
        if (_gridOff != null) {
            return _gridOff!!
        }
        _gridOff = materialIcon(name = "Rounded.GridOff") {
            materialPath {
                moveTo(8.0f, 4.0f)
                verticalLineToRelative(0.89f)
                lineToRelative(2.0f, 2.0f)
                lineTo(10.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.89f)
                lineToRelative(2.0f, 2.0f)
                lineTo(14.0f, 10.0f)
                verticalLineToRelative(0.89f)
                lineToRelative(2.0f, 2.0f)
                lineTo(16.0f, 10.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.89f)
                lineToRelative(2.0f, 2.0f)
                lineTo(20.0f, 16.0f)
                verticalLineToRelative(0.89f)
                lineToRelative(2.0f, 2.0f)
                lineTo(22.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(5.11f, 2.0f)
                lineToRelative(2.0f, 2.0f)
                lineTo(8.0f, 4.0f)
                close()
                moveTo(16.0f, 4.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(16.0f, 4.0f)
                close()
                moveTo(22.16f, 21.88f)
                lineTo(2.12f, 1.84f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(2.0f, 4.55f)
                lineTo(2.0f, 20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(15.45f)
                lineToRelative(1.3f, 1.3f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.03f, 0.0f, -1.42f)
                close()
                moveTo(10.0f, 12.55f)
                lineTo(11.45f, 14.0f)
                lineTo(10.0f, 14.0f)
                verticalLineToRelative(-1.45f)
                close()
                moveTo(4.0f, 6.55f)
                lineTo(5.45f, 8.0f)
                lineTo(4.0f, 8.0f)
                lineTo(4.0f, 6.55f)
                close()
                moveTo(8.0f, 20.0f)
                lineTo(5.0f, 20.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                close()
                moveTo(8.0f, 14.0f)
                lineTo(4.0f, 14.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(3.45f)
                lineToRelative(0.55f, 0.55f)
                lineTo(8.0f, 14.0f)
                close()
                moveTo(14.0f, 20.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(3.45f)
                lineToRelative(0.55f, 0.55f)
                lineTo(14.0f, 20.0f)
                close()
                moveTo(16.0f, 20.0f)
                verticalLineToRelative(-1.45f)
                lineTo(17.45f, 20.0f)
                lineTo(16.0f, 20.0f)
                close()
            }
        }
        return _gridOff!!
    }

private var _gridOff: ImageVector? = null
