/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FormatColorReset: ImageVector
    get() {
        if (_formatColorReset != null) {
            return _formatColorReset!!
        }
        _formatColorReset = materialIcon(name = "Rounded.FormatColorReset") {
            materialPath {
                moveTo(18.0f, 14.0f)
                curveToRelative(0.0f, -3.09f, -3.6f, -7.88f, -5.23f, -9.87f)
                curveToRelative(-0.4f, -0.49f, -1.15f, -0.49f, -1.55f, 0.0f)
                curveToRelative(-0.46f, 0.57f, -1.08f, 1.36f, -1.73f, 2.27f)
                lineToRelative(8.44f, 8.44f)
                curveToRelative(0.04f, -0.28f, 0.07f, -0.56f, 0.07f, -0.84f)
                close()
                moveTo(19.29f, 19.01f)
                lineTo(6.12f, 5.84f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.61f, 2.61f)
                curveTo(6.55f, 11.33f, 6.0f, 12.79f, 6.0f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveToRelative(1.52f, 0.0f, 2.9f, -0.57f, 3.95f, -1.5f)
                lineToRelative(1.92f, 1.92f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.4f, -0.38f, 0.4f, -1.02f, 0.01f, -1.41f)
                close()
            }
        }
        return _formatColorReset!!
    }

private var _formatColorReset: ImageVector? = null
