/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ElectricBike: ImageVector
    get() {
        if (_electricBike != null) {
            return _electricBike!!
        }
        _electricBike = materialIcon(name = "Rounded.ElectricBike") {
            materialPath {
                moveTo(19.0f, 7.0f)
                horizontalLineToRelative(-0.82f)
                lineToRelative(-1.7f, -4.68f)
                curveTo(16.19f, 1.53f, 15.44f, 1.0f, 14.6f, 1.0f)
                horizontalLineTo(13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.6f)
                lineToRelative(1.46f, 4.0f)
                horizontalLineToRelative(-4.81f)
                lineToRelative(-0.36f, -1.0f)
                horizontalLineToRelative(0.09f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(8.0f)
                curveTo(7.45f, 4.0f, 7.0f, 4.45f, 7.0f, 5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.75f)
                lineToRelative(1.82f, 5.0f)
                horizontalLineTo(9.9f)
                curveTo(9.46f, 8.77f, 7.59f, 7.12f, 5.25f, 7.01f)
                curveTo(2.45f, 6.87f, 0.0f, 9.2f, 0.0f, 12.0f)
                curveToRelative(0.0f, 2.8f, 2.2f, 5.0f, 5.0f, 5.0f)
                curveToRelative(2.46f, 0.0f, 4.45f, -1.69f, 4.9f, -4.0f)
                horizontalLineToRelative(4.2f)
                curveToRelative(0.44f, 2.23f, 2.31f, 3.88f, 4.65f, 3.99f)
                curveToRelative(2.8f, 0.13f, 5.25f, -2.19f, 5.25f, -5.0f)
                curveTo(24.0f, 9.2f, 21.8f, 7.0f, 19.0f, 7.0f)
                close()
                moveTo(6.0f, 13.0f)
                horizontalLineToRelative(1.82f)
                curveToRelative(-0.42f, 1.23f, -1.6f, 2.08f, -3.02f, 1.99f)
                curveTo(3.31f, 14.9f, 2.07f, 13.64f, 2.0f, 12.14f)
                curveTo(1.93f, 10.39f, 3.27f, 9.0f, 5.0f, 9.0f)
                curveToRelative(1.33f, 0.0f, 2.42f, 0.83f, 2.82f, 2.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveTo(5.0f, 12.55f, 5.45f, 13.0f, 6.0f, 13.0f)
                close()
                moveTo(14.1f, 11.0f)
                horizontalLineToRelative(-1.4f)
                lineToRelative(-0.73f, -2.0f)
                horizontalLineTo(15.0f)
                curveTo(14.56f, 9.58f, 14.24f, 10.25f, 14.1f, 11.0f)
                close()
                moveTo(18.88f, 15.0f)
                curveToRelative(-1.54f, -0.06f, -2.84f, -1.37f, -2.88f, -2.92f)
                curveToRelative(-0.02f, -0.96f, 0.39f, -1.8f, 1.05f, -2.36f)
                lineToRelative(0.62f, 1.7f)
                curveToRelative(0.19f, 0.52f, 0.76f, 0.79f, 1.28f, 0.6f)
                curveToRelative(0.52f, -0.19f, 0.79f, -0.76f, 0.6f, -1.28f)
                lineToRelative(-0.63f, -1.73f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.01f, -0.01f)
                curveTo(20.64f, 8.96f, 22.0f, 10.29f, 22.0f, 12.0f)
                curveTo(22.0f, 13.72f, 20.62f, 15.06f, 18.88f, 15.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 20.0f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(6.0f, 3.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(-6.0f, -3.0f)
                close()
            }
        }
        return _electricBike!!
    }

private var _electricBike: ImageVector? = null
