/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DesktopMac: ImageVector
    get() {
        if (_desktopMac != null) {
            return _desktopMac!!
        }
        _desktopMac = materialIcon(name = "Rounded.DesktopMac") {
            materialPath {
                moveTo(21.0f, 2.0f)
                lineTo(3.0f, 2.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.0f)
                lineToRelative(-1.63f, 2.45f)
                curveToRelative(-0.44f, 0.66f, 0.03f, 1.55f, 0.83f, 1.55f)
                horizontalLineToRelative(5.6f)
                curveToRelative(0.8f, 0.0f, 1.28f, -0.89f, 0.83f, -1.55f)
                lineTo(14.0f, 18.0f)
                horizontalLineToRelative(7.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(23.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(21.0f, 14.0f)
                lineTo(3.0f, 14.0f)
                lineTo(3.0f, 5.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(9.0f)
                close()
            }
        }
        return _desktopMac!!
    }

private var _desktopMac: ImageVector? = null
