/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BatteryChargingFull: ImageVector
    get() {
        if (_batteryChargingFull != null) {
            return _batteryChargingFull!!
        }
        _batteryChargingFull = materialIcon(name = "Rounded.BatteryChargingFull") {
            materialPath {
                moveTo(15.67f, 4.0f)
                lineTo(14.0f, 4.0f)
                lineTo(14.0f, 3.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                lineTo(8.33f, 4.0f)
                curveTo(7.6f, 4.0f, 7.0f, 4.6f, 7.0f, 5.33f)
                verticalLineToRelative(15.33f)
                curveTo(7.0f, 21.4f, 7.6f, 22.0f, 8.34f, 22.0f)
                horizontalLineToRelative(7.32f)
                curveToRelative(0.74f, 0.0f, 1.34f, -0.6f, 1.34f, -1.33f)
                lineTo(17.0f, 5.33f)
                curveTo(17.0f, 4.6f, 16.4f, 4.0f, 15.67f, 4.0f)
                close()
                moveTo(14.61f, 13.24f)
                lineToRelative(-2.67f, 5.0f)
                curveToRelative(-0.24f, 0.45f, -0.94f, 0.28f, -0.94f, -0.24f)
                verticalLineToRelative(-3.5f)
                lineTo(9.83f, 14.5f)
                curveToRelative(-0.38f, 0.0f, -0.62f, -0.4f, -0.44f, -0.74f)
                lineToRelative(2.67f, -5.0f)
                curveToRelative(0.24f, -0.45f, 0.94f, -0.28f, 0.94f, 0.24f)
                verticalLineToRelative(3.5f)
                horizontalLineToRelative(1.17f)
                curveToRelative(0.37f, 0.0f, 0.62f, 0.4f, 0.44f, 0.74f)
                close()
            }
        }
        return _batteryChargingFull!!
    }

private var _batteryChargingFull: ImageVector? = null
