/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SettingsInputHdmi: ImageVector
    get() {
        if (_settingsInputHdmi != null) {
            return _settingsInputHdmi!!
        }
        _settingsInputHdmi = materialIcon(name = "Outlined.SettingsInputHdmi") {
            materialPath {
                moveTo(18.0f, 7.0f)
                lineTo(18.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(8.0f, 2.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(3.0f)
                lineTo(5.0f, 7.0f)
                verticalLineToRelative(6.0f)
                lineToRelative(3.0f, 6.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(3.0f, -6.0f)
                lineTo(19.0f, 7.0f)
                horizontalLineToRelative(-1.0f)
                close()
                moveTo(8.0f, 4.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.01f)
                lineTo(13.99f, 5.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(2.0f)
                lineTo(11.0f, 7.0f)
                lineTo(11.0f, 5.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(2.0f)
                lineTo(8.0f, 7.0f)
                lineTo(8.0f, 4.0f)
                close()
                moveTo(17.0f, 12.53f)
                lineToRelative(-3.0f, 6.0f)
                lineTo(14.0f, 20.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-1.47f)
                lineToRelative(-3.0f, -6.0f)
                lineTo(7.0f, 9.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(3.53f)
                close()
            }
        }
        return _settingsInputHdmi!!
    }

private var _settingsInputHdmi: ImageVector? = null
