/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.RMobiledata: ImageVector
    get() {
        if (_rMobiledata != null) {
            return _rMobiledata!!
        }
        _rMobiledata = materialIcon(name = "Outlined.RMobiledata") {
            materialPath {
                moveTo(7.8f, 7.2f)
                lineTo(9.0f, 10.0f)
                horizontalLineTo(7.0f)
                lineTo(5.87f, 7.33f)
                horizontalLineTo(4.0f)
                verticalLineTo(10.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(1.13f, 0.0f, 2.0f, 0.87f, 2.0f, 2.0f)
                verticalLineToRelative(1.33f)
                curveTo(9.0f, 6.13f, 8.47f, 6.87f, 7.8f, 7.2f)
                close()
                moveTo(7.0f, 4.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(1.33f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(4.0f)
                close()
            }
        }
        return _rMobiledata!!
    }

private var _rMobiledata: ImageVector? = null
