/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Nat: ImageVector
    get() {
        if (_nat != null) {
            return _nat!!
        }
        _nat = materialIcon(name = "Outlined.Nat") {
            materialPath {
                moveTo(6.82f, 13.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(6.82f)
                curveTo(6.4f, 9.84f, 5.3f, 9.0f, 4.0f, 9.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                curveTo(5.3f, 15.0f, 6.4f, 14.16f, 6.82f, 13.0f)
                close()
                moveTo(4.0f, 13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(5.0f, 12.55f, 4.55f, 13.0f, 4.0f, 13.0f)
                close()
            }
            materialPath {
                moveTo(23.0f, 12.0f)
                lineToRelative(-4.0f, -3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.05f)
                curveTo(14.45f, 5.95f, 10.19f, 2.0f, 5.0f, 2.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(4.42f, 0.0f, 8.0f, 3.58f, 8.0f, 8.0f)
                reflectiveCurveToRelative(-3.58f, 8.0f, -8.0f, 8.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(5.19f, 0.0f, 9.45f, -3.95f, 9.95f, -9.0f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(2.0f)
                lineTo(23.0f, 12.0f)
                close()
            }
        }
        return _nat!!
    }

private var _nat: ImageVector? = null
