/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.MobiledataOff: ImageVector
    get() {
        if (_mobiledataOff != null) {
            return _mobiledataOff!!
        }
        _mobiledataOff = materialIcon(name = "Outlined.MobiledataOff") {
            materialPath {
                moveTo(16.0f, 6.82f)
                lineToRelative(1.59f, 1.59f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.59f, -1.59f)
                lineToRelative(0.0f, 4.35f)
                lineToRelative(2.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(1.39f, 4.22f)
                lineToRelative(6.61f, 6.61f)
                lineToRelative(0.0f, 6.35f)
                lineToRelative(-1.59f, -1.59f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-1.59f, 1.59f)
                lineToRelative(0.0f, -4.35f)
                lineToRelative(9.78f, 9.78f)
                lineToRelative(1.41f, -1.42f)
                lineToRelative(-18.38f, -18.38f)
                close()
            }
        }
        return _mobiledataOff!!
    }

private var _mobiledataOff: ImageVector? = null
