/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.AirlineSeatLegroomExtra: ImageVector
    get() {
        if (_airlineSeatLegroomExtra != null) {
            return _airlineSeatLegroomExtra!!
        }
        _airlineSeatLegroomExtra = materialIcon(name = "Outlined.AirlineSeatLegroomExtra") {
            materialPath {
                moveTo(4.0f, 12.0f)
                lineTo(4.0f, 3.0f)
                lineTo(2.0f, 3.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-2.0f)
                lineTo(7.0f, 15.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                close()
                moveTo(22.83f, 17.24f)
                curveToRelative(-0.38f, -0.72f, -1.29f, -0.97f, -2.03f, -0.63f)
                lineToRelative(-1.09f, 0.5f)
                lineToRelative(-3.41f, -6.98f)
                curveTo(15.96f, 9.45f, 15.27f, 9.0f, 14.51f, 9.0f)
                lineTo(11.0f, 9.0f)
                lineTo(11.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                horizontalLineToRelative(7.0f)
                lineToRelative(3.41f, 7.0f)
                lineToRelative(3.72f, -1.7f)
                curveToRelative(0.77f, -0.36f, 1.1f, -1.3f, 0.7f, -2.06f)
                close()
            }
        }
        return _airlineSeatLegroomExtra!!
    }

private var _airlineSeatLegroomExtra: ImageVector? = null
