/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MapsHomeWork: ImageVector
    get() {
        if (_mapsHomeWork != null) {
            return _mapsHomeWork!!
        }
        _mapsHomeWork = materialIcon(name = "Filled.MapsHomeWork") {
            materialPath {
                moveTo(1.0f, 11.0f)
                lineToRelative(0.0f, 10.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, -10.0f)
                lineToRelative(-7.0f, -5.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 3.0f)
                verticalLineToRelative(1.97f)
                lineToRelative(7.0f, 5.0f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(10.0f)
                close()
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                close()
            }
        }
        return _mapsHomeWork!!
    }

private var _mapsHomeWork: ImageVector? = null
