/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CropRotate: ImageVector
    get() {
        if (_cropRotate != null) {
            return _cropRotate!!
        }
        _cropRotate = materialIcon(name = "Filled.CropRotate") {
            materialPath {
                moveTo(7.47f, 21.49f)
                curveTo(4.2f, 19.93f, 1.86f, 16.76f, 1.5f, 13.0f)
                lineTo(0.0f, 13.0f)
                curveToRelative(0.51f, 6.16f, 5.66f, 11.0f, 11.95f, 11.0f)
                curveToRelative(0.23f, 0.0f, 0.44f, -0.02f, 0.66f, -0.03f)
                lineTo(8.8f, 20.15f)
                lineToRelative(-1.33f, 1.34f)
                close()
                moveTo(12.05f, 0.0f)
                curveToRelative(-0.23f, 0.0f, -0.44f, 0.02f, -0.66f, 0.04f)
                lineToRelative(3.81f, 3.81f)
                lineToRelative(1.33f, -1.33f)
                curveTo(19.8f, 4.07f, 22.14f, 7.24f, 22.5f, 11.0f)
                lineTo(24.0f, 11.0f)
                curveToRelative(-0.51f, -6.16f, -5.66f, -11.0f, -11.95f, -11.0f)
                close()
                moveTo(16.0f, 14.0f)
                horizontalLineToRelative(2.0f)
                lineTo(18.0f, 8.0f)
                curveToRelative(0.0f, -1.11f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(8.0f, 16.0f)
                lineTo(8.0f, 4.0f)
                lineTo(6.0f, 4.0f)
                verticalLineToRelative(2.0f)
                lineTo(4.0f, 6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                lineTo(8.0f, 16.0f)
                close()
            }
        }
        return _cropRotate!!
    }

private var _cropRotate: ImageVector? = null
