/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CircleNotifications: ImageVector
    get() {
        if (_circleNotifications != null) {
            return _circleNotifications!!
        }
        _circleNotifications = materialIcon(name = "Filled.CircleNotifications") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 18.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                close()
                moveTo(17.0f, 16.0f)
                lineTo(7.0f, 16.0f)
                verticalLineToRelative(-1.0f)
                lineToRelative(1.0f, -1.0f)
                verticalLineToRelative(-2.61f)
                curveTo(8.0f, 9.27f, 9.03f, 7.47f, 11.0f, 7.0f)
                verticalLineToRelative(-0.5f)
                curveToRelative(0.0f, -0.57f, 0.43f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.43f, 1.0f, 1.0f)
                lineTo(13.0f, 7.0f)
                curveToRelative(1.97f, 0.47f, 3.0f, 2.28f, 3.0f, 4.39f)
                lineTo(16.0f, 14.0f)
                lineToRelative(1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                close()
            }
        }
        return _circleNotifications!!
    }

private var _circleNotifications: ImageVector? = null
