/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AllInclusive: ImageVector
    get() {
        if (_allInclusive != null) {
            return _allInclusive!!
        }
        _allInclusive = materialIcon(name = "Filled.AllInclusive") {
            materialPath {
                moveTo(18.6f, 6.62f)
                curveToRelative(-1.44f, 0.0f, -2.8f, 0.56f, -3.77f, 1.53f)
                lineTo(12.0f, 10.66f)
                lineTo(10.48f, 12.0f)
                horizontalLineToRelative(0.01f)
                lineTo(7.8f, 14.39f)
                curveToRelative(-0.64f, 0.64f, -1.49f, 0.99f, -2.4f, 0.99f)
                curveToRelative(-1.87f, 0.0f, -3.39f, -1.51f, -3.39f, -3.38f)
                reflectiveCurveTo(3.53f, 8.62f, 5.4f, 8.62f)
                curveToRelative(0.91f, 0.0f, 1.76f, 0.35f, 2.44f, 1.03f)
                lineToRelative(1.13f, 1.0f)
                lineToRelative(1.51f, -1.34f)
                lineTo(9.22f, 8.2f)
                curveTo(8.2f, 7.18f, 6.84f, 6.62f, 5.4f, 6.62f)
                curveTo(2.42f, 6.62f, 0.0f, 9.04f, 0.0f, 12.0f)
                reflectiveCurveToRelative(2.42f, 5.38f, 5.4f, 5.38f)
                curveToRelative(1.44f, 0.0f, 2.8f, -0.56f, 3.77f, -1.53f)
                lineToRelative(2.83f, -2.5f)
                lineToRelative(0.01f, 0.01f)
                lineTo(13.52f, 12.0f)
                horizontalLineToRelative(-0.01f)
                lineToRelative(2.69f, -2.39f)
                curveToRelative(0.64f, -0.64f, 1.49f, -0.99f, 2.4f, -0.99f)
                curveToRelative(1.87f, 0.0f, 3.39f, 1.51f, 3.39f, 3.38f)
                reflectiveCurveToRelative(-1.52f, 3.38f, -3.39f, 3.38f)
                curveToRelative(-0.9f, 0.0f, -1.76f, -0.35f, -2.44f, -1.03f)
                lineToRelative(-1.14f, -1.01f)
                lineToRelative(-1.51f, 1.34f)
                lineToRelative(1.27f, 1.12f)
                curveToRelative(1.02f, 1.01f, 2.37f, 1.57f, 3.82f, 1.57f)
                curveToRelative(2.98f, 0.0f, 5.4f, -2.41f, 5.4f, -5.38f)
                reflectiveCurveToRelative(-2.42f, -5.37f, -5.4f, -5.37f)
                close()
            }
        }
        return _allInclusive!!
    }

private var _allInclusive: ImageVector? = null
