/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AirportShuttle: ImageVector
    get() {
        if (_airportShuttle != null) {
            return _airportShuttle!!
        }
        _airportShuttle = materialIcon(name = "Filled.AirportShuttle") {
            materialPath {
                moveTo(17.0f, 5.0f)
                lineTo(3.0f, 5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.89f, -2.0f, 2.0f)
                verticalLineToRelative(9.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.65f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.35f, 3.0f, -3.0f)
                horizontalLineToRelative(5.5f)
                curveToRelative(0.0f, 1.65f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.35f, 3.0f, -3.0f)
                lineTo(23.0f, 16.0f)
                verticalLineToRelative(-5.0f)
                lineToRelative(-6.0f, -6.0f)
                close()
                moveTo(3.0f, 11.0f)
                lineTo(3.0f, 7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                lineTo(3.0f, 11.0f)
                close()
                moveTo(6.0f, 17.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                close()
                moveTo(13.0f, 11.0f)
                lineTo(9.0f, 11.0f)
                lineTo(9.0f, 7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                close()
                moveTo(17.5f, 17.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                close()
                moveTo(15.0f, 11.0f)
                lineTo(15.0f, 7.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(4.0f, 4.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
        }
        return _airportShuttle!!
    }

private var _airportShuttle: ImageVector? = null
