/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SportsBaseball: ImageVector
    get() {
        if (_sportsBaseball != null) {
            return _sportsBaseball!!
        }
        _sportsBaseball = materialIcon(name = "TwoTone.SportsBaseball") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.61f, 7.22f)
                curveTo(4.6f, 8.55f, 4.0f, 10.2f, 4.0f, 12.0f)
                reflectiveCurveToRelative(0.6f, 3.45f, 1.61f, 4.78f)
                curveTo(7.06f, 15.69f, 8.0f, 13.95f, 8.0f, 12.0f)
                reflectiveCurveTo(7.06f, 8.31f, 5.61f, 7.22f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.0f, 12.0f)
                curveToRelative(0.0f, -2.52f, 1.17f, -4.77f, 3.0f, -6.24f)
                curveTo(15.63f, 4.66f, 13.89f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveTo(8.37f, 4.66f, 7.0f, 5.76f)
                curveToRelative(1.83f, 1.47f, 3.0f, 3.71f, 3.0f, 6.24f)
                reflectiveCurveToRelative(-1.17f, 4.77f, -3.0f, 6.24f)
                curveToRelative(1.37f, 1.1f, 3.11f, 1.76f, 5.0f, 1.76f)
                reflectiveCurveToRelative(3.63f, -0.66f, 5.0f, -1.76f)
                curveTo(15.17f, 16.77f, 14.0f, 14.52f, 14.0f, 12.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.39f, 7.22f)
                curveTo(16.94f, 8.31f, 16.0f, 10.05f, 16.0f, 12.0f)
                reflectiveCurveToRelative(0.94f, 3.69f, 2.39f, 4.78f)
                curveTo(19.4f, 15.45f, 20.0f, 13.8f, 20.0f, 12.0f)
                reflectiveCurveTo(19.4f, 8.55f, 18.39f, 7.22f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(5.61f, 16.78f)
                curveTo(4.6f, 15.45f, 4.0f, 13.8f, 4.0f, 12.0f)
                reflectiveCurveToRelative(0.6f, -3.45f, 1.61f, -4.78f)
                curveTo(7.06f, 8.31f, 8.0f, 10.05f, 8.0f, 12.0f)
                reflectiveCurveTo(7.06f, 15.69f, 5.61f, 16.78f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-1.89f, 0.0f, -3.63f, -0.66f, -5.0f, -1.76f)
                curveToRelative(1.83f, -1.47f, 3.0f, -3.71f, 3.0f, -6.24f)
                reflectiveCurveTo(8.83f, 7.23f, 7.0f, 5.76f)
                curveTo(8.37f, 4.66f, 10.11f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveToRelative(3.63f, 0.66f, 5.0f, 1.76f)
                curveToRelative(-1.83f, 1.47f, -3.0f, 3.71f, -3.0f, 6.24f)
                reflectiveCurveToRelative(1.17f, 4.77f, 3.0f, 6.24f)
                curveTo(15.63f, 19.34f, 13.89f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(18.39f, 16.78f)
                curveTo(16.94f, 15.69f, 16.0f, 13.95f, 16.0f, 12.0f)
                reflectiveCurveToRelative(0.94f, -3.69f, 2.39f, -4.78f)
                curveTo(19.4f, 8.55f, 20.0f, 10.2f, 20.0f, 12.0f)
                reflectiveCurveTo(19.4f, 15.45f, 18.39f, 16.78f)
                close()
            }
        }
        return _sportsBaseball!!
    }

private var _sportsBaseball: ImageVector? = null
